/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.driver.BasicCellRendererReader;
import org.fest.swing.driver.BasicJComboBoxCellReader;
import org.fest.swing.driver.CellRendererReader;
import org.fest.swing.driver.ModelValueToString;

public class BasicJTableCellReader
implements JTableCellReader {
    private final CellRendererReader rendererReader;
    private final BasicJComboBoxCellReader comboBoxCellReader = new BasicJComboBoxCellReader();

    public BasicJTableCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJTableCellReader(CellRendererReader reader) {
        if (reader == null) {
            throw new NullPointerException("CellRendererReader should not be null");
        }
        this.rendererReader = reader;
    }

    @RunsInCurrentThread
    public String valueAt(JTable table, int row, int column) {
        String value;
        Component c = this.cellRendererIn(table, row, column);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        if (c instanceof JLabel) {
            return ((JLabel)c).getText();
        }
        if (c instanceof JCheckBox) {
            return String.valueOf(((JCheckBox)c).isSelected());
        }
        if (c instanceof JComboBox) {
            return this.valueAsText((JComboBox)c);
        }
        return ModelValueToString.asText(table.getValueAt(row, column));
    }

    private String valueAsText(JComboBox comboBox) {
        int selectedIndex = comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return this.comboBoxCellReader.valueAt(comboBox, selectedIndex);
    }

    @RunsInCurrentThread
    public Font fontAt(JTable table, int row, int column) {
        Component c = this.cellRendererIn(table, row, column);
        return c != null ? c.getFont() : null;
    }

    @RunsInCurrentThread
    public Color backgroundAt(JTable table, int row, int column) {
        Component c = this.cellRendererIn(table, row, column);
        return c != null ? c.getBackground() : null;
    }

    @RunsInCurrentThread
    public Color foregroundAt(JTable table, int row, int column) {
        Component c = this.cellRendererIn(table, row, column);
        return c != null ? c.getForeground() : null;
    }

    @RunsInCurrentThread
    private Component cellRendererIn(JTable table, int row, int column) {
        return table.prepareRenderer(table.getCellRenderer(row, column), row, column);
    }
}

